"use strict";

(function () {
    let app = angular.module('workstationHrManager', []);
    app.directive('workstationHrManager', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/workstation/hrmanager.html',
            controller: function ($rootScope, $scope, $timeout) {
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;

                let loadView = () => {
                    ctrl.maxInCharge = Helpers.CalculateMaxInCharge($rootScope.selectedWorkstation.employee);

                    let employees = Helpers.GetAllEmployees();

                    let hrManagers = employees.filter(employee => employee.type == EmployeeTypeNames.HrManager && employee != $rootScope.selectedWorkstation.employee);
                    let notAvailableEmployeeIds = _.flatten(hrManagers.map(x => x.employees));
                    ctrl.managers = employees.filter(x => x.employeeTypeName == EmployeeTypeNames.Manager && !notAvailableEmployeeIds.some(employeeId => x.id == employeeId));

                    let selectedManagers = ctrl.managers.filter(x => $rootScope.selectedWorkstation.employee.employees.includes(x.id));
                    ctrl.controlledEmployees =
                        _.flatten(selectedManagers.map(x => x.employees.map(y => employees.find(e => e.id == y))))
                            .map(x => {
                                return {
                                    employee: x,
                                    schedule: moment(`${x.workingHours.start.hour}:${x.workingHours.start.minute}`, ["H:m"]).format('HH:mm') + " - "
                                    + moment(`${x.workingHours.end.hour}:${x.workingHours.end.minute}`, ["H:m"]).format('HH:mm')
                                };
                            });
                };

                $scope.$watch('selectedWorkstation', () => loadView(), true);

                this.isEmployeeActive = function (manager, employee) {
                    if (manager == null || employee == null || manager.employees == null) return null;

                    return manager.employees.some(id => id == employee.id);
                };

                this.setEmployeeToManager = function (manager, employee) {
                    let exists = this.isEmployeeActive(manager, employee);
                    if (exists) { // Disable
                        if (employee.task != null) employee.task.autoRepeat = false;

                        _.remove(manager.employees, id => {
                            return id == employee.id
                        });
                    } else { // Enable
                        if (manager.employees.length < ctrl.maxInCharge) {
                            manager.employees.push(employee.id);

                            // Enable auto repeat
                            if (employee.task != null) employee.task.autoRepeat = true;
                        }
                    }
                    $rootScope.$broadcast(GameEvents.EmployeeChange);
                };

                this.sendOnVacation = (employee) => {
                    employee.vacationHoursLeft = Configuration.VACATION_HOURS;
                    wallhack.sendEvent("vacation", `Mood: ${ Math.round(employee.mood) }%`);

                    let contract = null;
                    if ($rootScope.selectedWorkstation.employee.employeeTypeName == EmployeeTypeNames.SalesExecutive && $rootScope.selectedWorkstation.employee.contractId != null) {
                        contract = $rootScope.settings.contracts.find(x => x.id == employee.contractId);
                    }
                    if (contract != null) { // Sales Executive only
                        Helpers.CancelContract(contract);
                    }
                    $rootScope.$broadcast(GameEvents.EmployeeChange);
                };

                this.showEmployee = employee => {
                    $rootScope.view = null;
                    let workstation = $rootScope.settings.office.workstations.find(x => x.employee != null && x.employee.id == employee.id);
                    $rootScope.closeAllUi();
                    $timeout(() => {
                        $rootScope.selectedWorkstation = workstation;
                    });
                }
            },
            controllerAs: 'ctrl'
        }
    });

})();